<?php
/**
 * SEO Framework Support
 *
 * @package WCVendors_Pro
 *
 * @since 1.8.7
 * @version 1.8.7
 */
class WCV_SEO_Framework_Compatibility extends WCV_SEO_Compatibility {

    /**
     * WC Vendors Pro SEO Compatibility constructor.
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function __construct() {
        parent::__construct();
        $this->init_hooks();
    }

    /**
     * Init hooks
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function init_hooks() {
        global $post;
        if ( $this->is_vendor_store_page ) {
            add_filter( 'the_seo_framework_ogtitle_output', array( $this, 'override_store_og_title' ), 10, 1 );
            add_filter( 'the_seo_framework_ogurl_output', array( $this, 'override_store_og_url' ), 10, 1 );
            add_filter( 'the_seo_framework_ogsitename_output', array( $this, 'override_site_name_title' ), 10, 1 );
            add_filter( 'the_seo_framework_twittertitle_output', array( $this, 'override_store_twitter_title' ), 10, 1 );
            add_filter( 'the_seo_framework_title_from_generation', array( $this, 'override_site_title' ), 10, 1 );
        }

        if ( $this->is_product_page ) {

            add_filter( 'the_seo_framework_title_from_custom_field', array( $this, 'override_product_og_title' ), 10, 1 );
            add_filter( 'the_seo_framework_description_output', array( $this, 'override_product_og_description' ), 10, 1 );

            if ( $this->is_og_enable() ) {
                add_filter( 'the_seo_framework_ogtitle_output', array( $this, 'override_product_og_title' ), 10, 1 );
                add_filter( 'the_seo_framework_ogdescription_output', array( $this, 'override_product_og_description' ), 10, 1 );
                add_filter( 'the_seo_framework_ogsitename_output', array( $this, 'override_product_og_site_name' ), 10, 1 );
            }

            if ( $this->is_twitter_card_enable() ) {
                add_filter( 'the_seo_framework_twittertitle_output', array( $this, 'override_product_twitter_title' ), 10, 1 );
                add_filter( 'the_seo_framework_twitterdescription_output', array( $this, 'override_product_twitter_description' ), 10, 1 );
            }
        }
    }

    /**
     * Is enable
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @return bool
     */
    public function is_enable() {
        return is_plugin_active( 'autodescription/autodescription.php' );
    }

}
new WCV_SEO_Framework_Compatibility();
